from scipy.io import loadmat
import numpy as np

cars_root = '/home/visitor/SSD/data/Cars196/'
images_file = cars_root + 'cars_annos.mat'
train_file = cars_root + 'train.txt'
test_file = cars_root + 'test.txt'


def main():
    train = []
    test = []
    anno = loadmat(images_file)
    anno = anno['annotations'].squeeze(0)
    for id in range(len(anno)):
        img = [item.flat[0] for item in anno[id]]
        fname = img[0].encode('utf-8')
        label = img[5]
        if label <= 98:
            train.append((fname, label - 1)) # labels 0 ... 97 (0-based labels for margin_loss)
        else:
            test.append((fname, label - 1))  # labels 98 ... 195
    for f, v in [(train_file, train), (test_file, test)]:
        with open(f, 'w') as tf:
            for fname, label in v:
                tf.write("{},{}\n".format(fname,label))

if __name__ == '__main__':
    main()